// priority: 18

// =================================================================================================
// 特殊配方核心配置文件
//
// 这个文件定义了所有通过世界交互（如水池仪式、闪电仪式）进行的特殊配方的核心逻辑。
// 你可以通过修改下面的 `维度中文映射` 和 `世界交互配方列表` 来自定义你的游戏内容。
// =================================================================================================

// --- 维度中文名到ID的映射表 ---
// 在配方中，你可以方便地使用这里的中文名来指定维度，脚本会自动将其转换为正确的维度ID。
// 你可以根据需要添加更多模组维度的映射。
let 维度中文映射 = {
    "主世界": "minecraft:overworld",
    "下界": "minecraft:the_nether",
    "末地": "minecraft:the_end",
    "幽邃黑暗": "deeperdarker:otherside",
    "暮色森林": "twilightforest:twilight_forest",
};
// 在配方中，你可以方便地使用这里的中文名来指定结构。
let 结构中文映射 = {
    "平原村庄": "minecraft:village_plains",
    "末地城": "minecraft:end_city",
    "下界要塞": "minecraft:fortress",
    "废弃矿井": "minecraft:mineshaft"
    // 在这里添加更多你需要的结构映射
}

// =================================================================================================
// 世界交互配方列表
//
// 在下面的 "global.世界交互配方列表" 中，你可以添加任意数量的配方。
// 每个配方都是一个用 `{}` 包裹的对象，对象之间用逗号 `,` 分隔。
//
// --- 配方属性详解 ---
//
// "ID": (必需)
//     - 类型: 字符串 (String)
//     - 说明: 一个方便你识别这个配方的中文或英文名字，不会在游戏内显示，仅用于配置。
//     - 示例: "ID": "合成钻石块",
//
// "合成材料": (必需)
//     - 类型: 字符串列表 (Array of Strings)
//     - 说明: 定义了合成一份成品所需的基础材料比例。脚本会自动根据投入的材料计算最大可合成份数。
//     - 格式: 
//         - '物品ID' (代表需要1个)
//         - '数量x 物品ID' (代表需要指定数量)
//         - 如果需要NBT，请直接写在物品ID后面，例如: 'minecraft:enchanted_book{StoredEnchantments:[{id:"minecraft:sharpness",lvl:5s}]}'
//     - 示例: "合成材料": ["9x minecraft:diamond", "minecraft:nether_star"],
//
// "输出物品": (必需)
//     - 类型: 字符串 (String)
//     - 说明: 仪式成功后生成的物品ID，同样支持NBT。
//     - 示例: "输出物品": "minecraft:diamond_block",
//
// "输出数量": (可选)
//     - 类型: 整数 (Integer)
//     - 说明: 定义了每进行一次合成（消耗一份材料）所产出的物品数量。默认为 1。
//     - 示例: "输出数量": 2,
//
// "触发方式": (可选)
//     - 类型: 字符串 (String)
//     - 可选值: '水池', '闪电', '全部'。
//     - 说明: 定义了这个配方可以通过哪种方式触发。默认为 '全部' (即水池和闪电都可以)。
//     - 示例: "触发方式": "水池",
//
// "维度": (可选)
//     - 类型: 字符串列表 (Array of Strings)
//     - 说明: 一个列表，定义了此仪式可以生效的维度。现在可以直接使用上面 `维度中文映射` 中定义的中文名。
//     - 如果不填写此项，则仪式可以在所有维度生效。
//     - 示例: "维度": ["主世界", "下界"],
//
// "需要经验值": (可选)
//     - 类型: 整数 (Integer)
//     - 说明: 定义了每进行一次合成需要消耗的玩家经验**点数** (不是等级)。
//     - 如果玩家经验不足，仪式将失败并给出提示。
//     - 示例: "需要经验值": 100,
//
// "需要结构": (可选, 强烈推荐为Boss召唤等重要仪式添加此项)
//     - 类型: 字符串 (String)
//     - 说明: 定义了仪式必须在哪个结构内部才能进行。可以极大地增加仪式的独特性和挑战性。
//     - 格式: 必须是完整的结构ID，例如 "minecraft:bastion_remnant"。
//     - 示例: "需要结构": "minecraft:end_city",
//
// --- 仅水池仪式可用属性 ---
//
// "结构方块": (可选, 仅用于水池仪式)
//     - 类型: 字符串列表 (Array of Strings)
//     - 说明: 定义了构成水池祭坛的方块和所需数量。脚本会检查2x2水池周围一圈的12个方块。
//     - 格式与 "合成材料" 相同。
//     - 示例: "结构方块": ["8x minecraft:purpur_block", "4x minecraft:end_rod"],
//
// "仪式高度": (可选, 仅用于水池仪式)
//     - 类型: 整数 (Integer)
//     - 说明: 精确定义仪式水池所在的Y轴高度。
//     - 示例: "仪式高度": 64,
//
// --- 仅闪电仪式可用属性 ---
//
// "闪电Y轴限制": (可选, 仅用于闪电仪式)
//     - 类型: 整数 (Integer)
//     - 说明: 定义了触发闪电仪式的最低Y轴高度（大于等于此高度才有效）。
//     - 示例: "闪电Y轴限制": 200,
//
// =================================================================================================

global.世界交互配方列表 = [
    // --- 示例1：一个基础的水池仪式，带结构和维度限制 ---
    // 这个仪式只能在主世界（overworld）进行。
    // 它需要1个泥土作为材料，并且水池周围必须有至少4个橡木原木。
    // 玩家必须拥有至少50点经验值，仪式会消耗掉它们。
    /*{
        "ID": "水池测试：泥土变钻石",
        "合成材料": [
            "1x minecraft:dirt"
        ],
        "结构方块": [
            "4x minecraft:oak_log"
        ],
        "输出物品": "minecraft:diamond",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["主世界"] 
    },

    // --- 示例2：一个需要玩家进度和经验的闪电仪式 ---
    // 这个仪式需要2根木棍，被闪电劈中后，会变成1个烈焰棒。
    // 但前提是：
    // 玩家必须拥有至少50点经验值，仪式会消耗掉它们。
    {
        "ID": "闪电测试：木棍变烈焰棒",
        "合成材料": [
            "2x minecraft:stick"
        ],
        "输出物品": "minecraft:blaze_rod",
        "输出数量": 1,
        "触发方式": "闪电",
        "需要经验值": 50
    },

    // --- 示例3：一个只能在下界进行的水池仪式, 我知道水无法在下届放出来，所以这个仪式不会成功。 ---
    // 这个仪式只能在下界进行，用来测试维度锁。
    {
        "ID": "下界专属：荧石粉变烈焰粉",
        "合成材料": [
            "4x minecraft:glowstone_dust"
        ],
        "输出物品": "minecraft:blaze_powder",
        "触发方式": "水池",
        "维度": ["下届"]
    },
        {
        "ID": "召唤末影龙蛋",
        "合成材料": [
            "16x minecraft:chorus_fruit",
            "minecraft:dragon_breath"
        ],
        "输出物品": "minecraft:dragon_egg",
        "触发方式": "水池",
        "维度": ["末地"],
        "需要结构": "末地城", 
        "结构方块": [
            "8x minecraft:purpur_block",
            "4x minecraft:end_rod"
        ],
        "需要经验值": 1000
    }*/
{
        "ID": "永恒锭合成",
        "合成材料": ["enigmaticlegacy:evil_ingot","l2complements:poseidite_ingot","cataclysm:cursium_ingot", "cataclysm:ignitium_ingot" ,"l2complements:shulkerate_ingot","twilightforest:fiery_ingot","enigmaticlegacy:etherium_ingot","aquamirae:ship_graveyard_echo"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "eternisstarrysky:bag",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 1000,
        "维度": ["末地"] 
    },
    {
        "ID": "以太之心合成",
        "合成材料": ["12x enigmaticlegacy:etherium_ingot", "enigmaticlegacy:golem_heart","enigmaticlegacy:cosmic_heart"],
        "输出物品": "enigmaticaddons:etherium_core",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "以太鞋子",
        "合成材料": ["4x enigmaticlegacy:etherium_ingot","minecraft:diamond_boots"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "enigmaticlegacy:etherium_boots",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "以太胸甲",
        "合成材料": ["4x enigmaticlegacy:etherium_ingot","minecraft:diamond_chestplates"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "enigmaticlegacy:etherium_chestplate",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "以太裤子",
        "合成材料": ["4x enigmaticlegacy:etherium_ingot","minecraft:diamond_leggings"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "enigmaticlegacy:etherium_leggings",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "以太头盔",
        "合成材料": ["4x enigmaticlegacy:etherium_ingot","minecraft:diamond_helmet"],
        "输出物品": "enigmaticlegacy:etherium_helmet",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "永恒1",
        "合成材料": ["cataclysm:ignitium_helmet","enigmaticlegacy:etherium_helmet","l2complements:sculkium_helmet","eternisstarrysky:bag"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "eternisstarrysky:infinity_eternal_helmet",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "永恒2",
        "合成材料": ["cataclysm:ignitium_chestplate","enigmaticlegacy:etherium_chestplate","l2complements:sculkium_chestplate","eternisstarrysky:bag"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "eternisstarrysky:infinity_eternal_chestplate",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "永恒3",
        "合成材料": ["cataclysm:ignitium_leggings","enigmaticlegacy:etherium_leggings","l2complements:sculkium_leggings","eternisstarrysky:bag"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "eternisstarrysky:infinity_eternal_leggings",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "永恒4",
        "合成材料": ["cataclysm:ignitium_boots","enigmaticlegacy:etherium_boots","l2complements:sculkium_boots","eternisstarrysky:bag"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "eternisstarrysky:infinity_eternal_boots",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "毕业仪式合成",
        "合成材料": ["goety:unholy_blood","enigmaticlegacy:the_cube","8x enigmaticlegacy:etherium_ingot","6x cataclysm:ignitium_ingot","kubejs:inspiration_crown","6x cataclysm:cursium_ingot","enigmaticaddons:etherium_core","goety:night_beacon","4x eternisstarrysky:bag","enigmaticaddons:pure_heart"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "eternisstarrysky:infinity_sword",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    },
    {
        "ID": "苹果",
        "合成材料": ["enigmaticlegacy:forbidden_fruit","enigmaticlegacy:unholy_grail","minecraft:golden_apple","minecraft:enchanted_golden_apple","vanillacookbook:netherite_apple"],
        "结构方块": ["8x minecraft:purpur_block"],
        "输出物品": "eternisstarrysky:eternis_apple",
        "输出数量": 1,
        "触发方式": "水池",
        "需要经验值": 10,
        "维度": ["末地"] 
    }
];